/********************************************************************************/
/*																				*/
/*	Kroenke, Auer, Vandenberg & Yoder											*/
/*  Database Concepts (8th Edition) Chapter 03, Appendix E						*/
/*																				*/
/*	Wedgewood Pacific (WP) - SQL Statements										*/
/*																				*/
/*	These are the Microsoft Access 2016 SQL code solutions						*/
/*																				*/
/********************************************************************************/

/********************************************************************************/

/***  This is the Microsoft Access 2016 SQL Statement   *************************/
/***  The resulting table needs to be modified within Microsoft Access   ********/
/***  See the discussion in the Instructor's Manual   ***************************/

CREATE  TABLE COMPUTER(	
	SerialNumber		Int						NOT NULL,
	Make				Char(12)				NOT NULL,
	Model				Char(24)				NOT NULL,
	ProcessorType		Char(24)				NULL,
	ProcessorSpeed		Numeric					NOT NULL,
	MainMemory			Char(15)				NOT NULL,
	DiskSize			Char(15)				NOT NULL,
	CONSTRAINT 		COMPUTER_PK 				PRIMARY KEY(SerialNumber)
	);

/********************************************************************************/

INSERT INTO COMPUTER VALUES(
		9871234, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		9871235, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		9871236, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		9871237, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		9871238, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		9871239, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		9871240, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		9871241, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		9871242, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		9871243, 'HP', 'ProDesk 600 G1', 'Intel i5-4690', 3.50,	'16.0 GBytes', '1.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541001, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541002, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541003, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541004, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541005, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541006, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541007, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541008, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541009, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);
INSERT INTO COMPUTER VALUES(
		6541010, 'Dell', 'OptiPlex 7040', 'Intel i7-6700', 3.40, '32.0 GBytes', '2.0 TBytes'
		);

/********************************************************************************/
/***  This is the Microsoft Access 2016 SQL Statement   *************************/
/***  The resulting table needs to be modified within Microsoft Access   ********/
/***  See the discussion in the Instructor's Manual   ***************************/

CREATE  TABLE COMPUTER_ASSIGNMENT(
	SerialNumber		Int							NOT NULL,
	EmployeeNumber		Int	 						NOT NULL,
	DateAssigned		Date						NOT NULL,
	DateReassigned		DateTime					NULL,
	CONSTRAINT 			COMP_ASSIGN_PK 	
								PRIMARY KEY(SerialNumber, EmployeeNumber, DateAssigned),
	CONSTRAINT 			COMP_ASSIGN_EMPLOYEE	FOREIGN KEY(EmployeeNumber)
								REFERENCES EMPLOYEE(EmployeeNumber),
	CONSTRAINT 			COMP_ASSIGN_COMPUTER	FOREIGN KEY(SerialNumber)
								REFERENCES COMPUTER(SerialNumber)
	);


/********************************************************************************/

INSERT INTO COMPUTER_ASSIGNMENT VALUES(
		9871234, 12, '15-Sep-17', '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT	VALUES(
		9871235, 13, '15-Sep-17', '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT VALUES(
		9871236, 14, '15-Sep-17', '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT VALUES(
		9871237, 15, '15-Sep-17', '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT VALUES(
		9871238, 6, '15-Sep-17', '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT VALUES(
		9871239, 7, '15-Sep-17', '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT VALUES(
		9871240, 8, '15-Sep-17', '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT VALUES(
		9871241, 9, '15-Sep-17', '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT VALUES(
		9871242, 16, '15-Sep-17', '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT VALUES(
		9871243, 17, '15-Sep-17', '21-Oct-17');

INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541001, 12, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541002, 13, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541003, 14, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541004, 15, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541005, 6, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541006, 7, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541007, 8, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541008, 9, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541009, 16, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(6541010, 17, '21-Oct-17');

INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871234, 1, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871235, 2, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871236, 3, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871237, 4, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871238, 5, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871239, 10, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871240, 11, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871241, 18, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871242, 19, '21-Oct-17');
INSERT INTO COMPUTER_ASSIGNMENT (SerialNumber, EmployeeNumber, DateAssigned)
		VALUES(9871243, 20, '21-Oct-17');

/********************************************************************************/